<?php

namespace App\Controllers;
use App\Models\UserPermissionModel;
use App\Models\UserRoleModel;
use App\Models\UserModel;
use App\Models\FunctionalityModel;
use App\Controllers\BaseController;

class UserPermissionsController extends BaseController
{
    public function __construct(){
        
        helper(['url','form','app']);
        $this->UserPermissionModel = new UserPermissionModel();
        $this->URmodel = new UserRoleModel();
        $this->Umodel = new UserModel();
        $this->rulmodel = new FunctionalityModel();
    }
    // insert data
    public function insert() {
        $validation = $this->validate([
            // 'dpval' => [
            //     'rules'=>'required',
            //     'errors'=>[
            //         'required'=>'Please select a type',
            //     ],
            // ],
            'FID' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select a functionality',
                ],
            ],

        ]);
        $urId = $this->request->getVar('UPID');
        if($validation){ 

        //     print_r('$data');
        //   die();

            if($urId == ''){  //insert user role data
            $data = [
                // 'RoleID' => $this->request->getVar('RoleID'),
                // 'UserID'  => $this->request->getVar('UserID'),
                'RBCreatedAt' => date('Y-m-d H:i:s'),
                'RBStatus' => '1',              
            ];
           
            $funID = $this->request->getVar('FID');
            $data['FID'] = implode(',',$funID);
            if(isset($_POST['RoleID'])){
                $data['RoleID']=$this->request->getVar('RoleID');
                $data['UserID']=0;
            }
            elseif(isset($_POST['UserID'])){
                $data['UserID']=$this->request->getVar('UserID');
                $data['RoleID']=0;
            }
            $result=  $this->UserPermissionModel->insertuPermissionData($data);
        }
        else{  //update  user role data
         
            $data = [
                'RoleID' => $this->request->getVar('RoleID'),
                'UserID'  => $this->request->getVar('UserID'),
                'RBUpdatedAt' => date('Y-m-d H:i:s'),
                'RBStatus' => '1',
            ];     
            $funID = $this->request->getVar('FID');
            $data['FID'] = implode(',',$funID);
            if(isset($_POST['RoleID'])){
                $data['RoleID']=$this->request->getVar('RoleID');
                $data['UserID']=0;
            }
            elseif(isset($_POST['UserID'])){
                $data['UserID']=$this->request->getVar('UserID');
                $data['RoleID']=0;
            }
             
            $result = $this->UserPermissionModel->updatePermission($urId, $data);           
        }
        
            return $this->response->redirect(site_url('/userpermissions'));      
        }
        else{
            // print_r('$data2');
            // die();
  
            $user_info = getUserInfo();
            $has_errors = 'true';
            $up['User Permissions'] =  $this->UserPermissionModel->getUPIndexData();
            $ur['User Roles'] =  $this->URmodel->getUrolesIndexData();
            $u['Users'] =  $this->Umodel->getUserIndexData();
            $rules['Rules'] = $this->rulmodel->getFunctionalitiesIndexData();
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'User Permissions',
                'link' => 'userpermissions',
                'sources' => $up,
                'userroles' =>$ur,
                'users' => $u,
                'rules' => $rules,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
                'validation'=>$this->validator,
                'RoleID' => $this->request->getVar('RoleID'),
                'UserID'  => $this->request->getVar('UserID'),
            );                                                   
            return view('/userpermissions', $data);
        }
    }
    public function index()
    {
            $loggedUserID = session()->get('loggedUser');
            $user_info = $this->Umodel->getSingleUserData($loggedUserID);
            $user_info = getUserInfo();
            $up['User Permissions'] = $this->UserPermissionModel->getUPIndexData();
            $ur['User Roles'] = $this->URmodel->getUrolesIndexData();
            $u['Users'] = $this->Umodel->getUserIndexData();
            $rules['Rules'] =  $this->rulmodel->getFunctionalitiesIndexData();
            $has_errors = 'false';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'User Permissions',
                'link' => 'userpermissions',
                'sources' => $up,
                'userroles' =>$ur,
                'users' => $u,
                'rules' => $rules,
                'userinfo' => $user_info,
                'has_errors' => $has_errors,
            );                                                               
            return view('userpermissions', $data);
    }   
    //get single data
    public function singleData($id = null) {     
            $data=$this->UserPermissionModel->getSingleUserPermissionData($id);
            // echo '<pre>';
            // print_r($data);
            //   die();
            if($data){
                echo json_encode(array("status" => true , 'data' => $data));
            }else{
                echo json_encode(array("status" => false));
            }
    }
     //update
     public function update(){         
            $id = $this->request->getVar('RBID');
            $data = [
                'RoleID' => $this->request->getVar('RoleID'),
                'UserID'  => $this->request->getVar('UserID'),
                'RBUpdatedAt' => date('Y-m-d H:i:s'),
                'RBStatus' => '1',
            ];     
            $array = $_POST['FID'];
            $data['FID'] = implode(',',$array);   
            $result = $this->UserPermissionModel->updatePermission($id, $data);
            if($result) {
                return $this->response->redirect(site_url('/userpermissions'));
            }
            else{
                echo "Something went wrong";
            }
    }
     // delete employee
     public function delete($id = null){
            $now = date("Y-m-d H:i:s");
            $data = [
                'RBDeletedAt' => $now,
                'RBStatus' => '0',
            ];
            $this->UserPermissionModel->deleteUserPer($id, $data);
            return $this->response->setJSON([
                'error' => false,
                'message' => 'Successfully deleted!'
            ]);
            return $this->response->redirect(site_url('/suppliers'));
    }

}
